% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{eTSMSN}
\alias{eTSMSN}
\title{Estimate the parameters of Truncated Scale Mixtures of Skew-Normal Distributions}
\usage{
eTSMSN(x, mu = 0.01, sigma2 = 1.01, lambda = 0, nu = 5, a = -Inf,
  b = Inf, dist = "SN", shape = FALSE)
}
\arguments{
\item{x}{Dataset.}

\item{mu}{Initial location parameter (Optional).}

\item{sigma2}{Initial scale parameter (Optional).}

\item{lambda}{Initial skewness parameter (Optional).}

\item{nu}{Fixed shape parameter.  Must be NULL in case of Skew-Normal distribution.  Must be a bidimensional vector in case of skew-contaminated normal distribution (SCN) and contaminated normal distribution (CN).}

\item{a}{Lower bound.}

\item{b}{Upper bound.}

\item{dist}{Distribution to be used:  "SN" for Skew-Normal model, "ST" for Skew-t model, "SSL" for Skew-slash model and "SCN" for Skew-contaminated Normal model.}

\item{shape}{For ST, SSL and SCN distribution. Consider the parameter nu as fixed and known. If TRUE nu must be provided.}
}
\value{
Returns a vector with the maximum likelihood estimators of the distribution parameters.
}
\description{
This function obtains the maximum likelihood estimators of the TSMSN (Skew-Normal, Skew-t, Skew-Slash and Skew-Contaminated Normal) distribution parameters by direct maximization.
}
\details{
For the SMN family, consider lambda = 0. For the Skew-contaminated Normal and Contaminated Normal distribution, each component of the bidimensional vector "nu" must be on (0,1). For the estimation in the cases of distributions ST, SSL and SCN nu is considered fixed, but may be known or unknown. The shape parameter is the one that regulates if nu is known or unknown.
}
\examples{
x <- rTSMSN(n = 100, mu = 0, sigma2 = 1, lambda = 0, nu = NULL, a = -2, b = 2, dist = "SN")
eTSMSN(x, a = -2, b = 2, dist = "SN")
}
\references{
Lachos, V. H.; Garay, A. M.; Cabral, C. R. "Moments of truncated scale mixtures of skew-normal distributions." Brazilian Journal of Probability and Statistics (In press).

Basso, Rodrigo M., et al. "Robust mixture modeling based on scale mixtures of skew-normal distributions." Computational Statistics & Data Analysis 54.12 (2010): 2926-2941.
}
