#' Make a prediction from a fitted model
#' @description Make a prediction from a fitted TTR.PGM model. 
#' @details \code{predict_ttr()} returns the data object specified when the option 
#' 'Data$options$optim' in the user defined Model is set to "no". 
#' See the vignette for an example.
#' @param parms A vector of parameters compatible with the data object 'Data' and the user defined Model function
#' @param Model A user defined Model function that accepts 'parms' and 'Data' as input
#' @param Data A Data object as produced by \code{make_data()}
#' @param new.input If the prediction should use different forcing data from 'Data', this can be an input object as returned by \code{get_input()}
#' @param options If the prediction should use different options from 'Data', this can be supplied as an options list as required by \code{make_data()}
#' @param optim If the user defined Model function tests for 'optim' in options, this can be used to set it. Defaults to the string "no"
#' @return The prediction as specified in the user defined Model function
#' @export predict_ttr
#' @export
predict_ttr <- function(parms, Model, Data, new.input = NULL, options = NULL, optim = NULL){
  if(missing(options)){
    options <- Data$options
  }
  if(!missing(new.input)){
    new.data <- make_data(new.input, options, Data$arguments$globals, Data$arguments$bounds, Data$arguments$groups)
  }
  else{
    new.data <- Data
    new.data$options <- options
  }
  if(missing(optim))
    optim <- "no"
  new.data$options$optim <- optim
  Model(parms, new.data)
}
