% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_input.R
\name{get_input}
\alias{get_input}
\title{Create an input data object for \code{make_data()}}
\usage{
get_input(
  observations,
  tcur,
  tnur,
  tgrowth,
  tloss,
  seconds,
  p3 = TTR.PGM::p3,
  p4 = TTR.PGM::p4,
  lon = NULL,
  lat = NULL,
  rsds = NULL,
  catm = NULL,
  photoc3 = NULL,
  photoc4 = NULL,
  swc = NULL,
  pet = NULL,
  rain = NULL,
  wp = NULL,
  fc = NULL,
  fire = NULL,
  nsoil = NULL
)
}
\arguments{
\item{observations}{The observation data that will be used in the statistical model, there are no checks performed, so make sure to format this in the way the user defined statistical model expects}

\item{tcur}{matrix with ntimesteps rows, nsites columns, containing the temperature associated with photosynthesis [°C]}

\item{tnur}{matrix with ntimesteps rows, nsites columns, containing the temperature associated with nitrogen uptake [°C]}

\item{tgrowth}{matrix with ntimesteps rows, nsites columns, containing the temperature associated with growth [°C]}

\item{tloss}{matrix with ntimesteps rows, nsites columns, containing the temperature associated with biomass loss [°C]}

\item{seconds}{The number of seconds in a time step}

\item{p3}{The parameters to be used to calculate C3 photosynthesis rates (see \code{p3})}

\item{p4}{The parameters to be used to calculate C4 photosynthesis rates (see \code{p4})}

\item{lon}{vector of length nsite containing the Longitudes of the sites}

\item{lat}{vector of length nsite containing the Latitudes of the sites}

\item{rsds}{matrix with ntimesteps rows, nsites columns, containing short wave downward solar radiation at the surface [W*m^(-2)]}

\item{catm}{matrix with ntimesteps rows, nsites columns, containing Partial pressure of CO2 in the atmosphere [Pa]}

\item{photoc3}{matrix with ntimesteps rows, nsites columns, containing c3 photosynthesis rates [mumol*m^(-2)*s^(-1)]}

\item{photoc4}{matrix with ntimesteps rows, nsites columns, containing c4 photosynthesis rates [mumol*m^(-2)*s^(-1)]}

\item{swc}{matrix with ntimesteps rows, nsites columns, containing soil water content scaled so that wilting point = 0 and field capacity = 100 [\%]}

\item{pet}{matrix with ntimesteps rows, nsites columns, containing potential evapotranspiration [kg*m^(-2)*s^(-1)]}

\item{rain}{matrix with ntimesteps rows, nsites columns, containing precipitation [kg*m^(-2)*s^(-1)]}

\item{wp}{vector of length nsites containing wilting points [cm^3/cm^3]}

\item{fc}{vector of length nsites containing field capacities [cm^3/cm^3]}

\item{fire}{matrix with ntimesteps rows, nsites columns, containing binary information on fire occurrence [no units]; currently not supported}

\item{nsoil}{vector of length nsites containing the soil nitrogen content [kg/kg]}
}
\value{
A list containing the forcing data for the process model:
\item{timeseries}{
All forcing variables which change with time
}
\item{timeinvariant}{
All forcing variables which do not change with time
}
\item{observations}{
Observations as specified above
}
}
\description{
This function takes the input forcing data and formats it for use by the \code{make_data()} function.
The input forcing data are expected to have the units specified below.
All of the forcing data should be in dataframe or matrix form.
The following constant dimension sizes are expected:

nspecies : The number of species

nsites : The number of sites

nsteps : The number of timesteps

Currently only one species is supported.
Depending on the model configuration different parameters need to be specified. tcur, tnur, tgrowth and tloss always need to be supplied. For the std variant of the process model, rsds has to be specified as well. For other variants  photosynthesis rates can be supplied or calculated from tcur, catm and rsds. Soil water content needs to be supplied or it will be calculated from wp, fc, prec and pet. nsoil is optional. fire is currently not supported.
}
