% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airfieldgame.R
\name{airfieldgame}
\alias{airfieldgame}
\title{Airfield game}
\usage{
airfieldgame(c, binary = FALSE)
}
\arguments{
\item{c}{A vector of costs defining the airfield problem.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the airfield game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given an airfield problem, this function returns the associated airfield game.
}
\details{
Let \eqn{N = \{1, \dots, n\}} denote a set of agents, and let \eqn{c \in \mathbb{R}_+^N} be a cost vector.
Each \eqn{c_i} represents the cost of the service required by agent \eqn{i}.
Segmental costs are defined as the difference between a given cost and the first immediately lower cost: \eqn{c_i - c_{i-1}} for \eqn{i \in N \backslash \{1\}}.

Each \eqn{c \in \mathbb{R}_+^N} defines an airfield problem, which is associated to an airfield game \eqn{v_{a}\in G^N}, is defined by
\deqn{v_{a}(S)=\max\{c_j:j\in S\}\text{ for all }S\in 2^N.}

Airfield games, as defined, are cost games, but they can also be expressed as savings games.
Additional tools and methods for addressing airfield problems are available
in the \pkg{AirportProblems} package \cite{Bernárdez Ferradás et al. (2025)}.
}
\examples{
c <- c(2000,3200,4100,5100)
airfieldgame(c,binary=TRUE)
}
\references{
Bernárdez Ferradás, A., Sánchez Rodríguez, E., Mirás Calvo, M., & Quinteiro Sandomingo, C. (2025). \emph{AirportProblems: Analysis of Cost Allocation for Airport Problems}. R package version 0.1.0. \url{https://CRAN.R-project.org/package=AirportProblems}

Littlechild, S.C., & Owen, G. (1973). A Simple Expression for the Shapely Value in a Special Case. \emph{Management Science}, 23, 370-372.
}
\seealso{
\link{claimsgame}, \link{savingsgame}
}
