% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelex2bin.R
\name{codelex2bin}
\alias{codelex2bin}
\title{Lexicographic order position to binary order position}
\usage{
codelex2bin(n, Nlex)
}
\arguments{
\item{n}{Number of players.}

\item{Nlex}{A lexicographic order position, as an integer between 1 and \eqn{2^{\code{n}}-1}.}
}
\value{
The corresponding binary order position, as an integer between 1 and \eqn{2^{\code{n}}-1}.
}
\description{
Given the lexicographic order position of a coalition, this function returns the  corresponding binary order position.
}
\details{
Lexicographic order arranges coalitions in ascending order according to size, and applies lexicographic order to break ties among coalitions of the same size. The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}.
}
\examples{
codelex2bin(5, 4)
}
\seealso{
\link{bin2lex}, \link{codebin2lex}, \link{lex2bin}
}
