% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcoalition.R
\name{getcoalition}
\alias{getcoalition}
\title{Get coalition}
\usage{
getcoalition(num)
}
\arguments{
\item{num}{A binary order position of a coalition, as an integer.}
}
\value{
The players that form the coalition whose binary order position is the given integer, as a vector.
}
\description{
This function returns the players that form the coalition whose binary order position coincides with the given integer.
}
\details{
A coalition \eqn{S\in 2^N} can be represented by the \eqn{n}-digit binary number \eqn{s_1\dots s_n} in which \eqn{s_i=1} if \eqn{i\in S} and \eqn{s_i=0} otherwise. The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}.
}
\examples{
num <- 5
getcoalition(num)
n <- 4
for (i in 1:(2^n - 1)){
  cat("[", i, "]", paste(getcoalition(i)),"\n")
}
}
\seealso{
\link{codebin2lex}, \link{codelex2bin}, \link{getcoalitionnumber}
}
