% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcoalitionnumber.R
\name{getcoalitionnumber}
\alias{getcoalitionnumber}
\title{Get coalition number}
\usage{
getcoalitionnumber(S)
}
\arguments{
\item{S}{The players forming the coalition, as a vector.}
}
\value{
The binary order position of the coalition formed by the given players.
}
\description{
This function returns the binary order position of the coalition formed by the given players.
}
\details{
A coalition \eqn{S\in 2^N} can be represented by the \eqn{n}-digit binary number \eqn{s_1\dots s_n} where \eqn{s_i=1} if \eqn{i\in S} and \eqn{0} otherwise. The binary order position of a coalition \eqn{S\in 2^N} is given by  \eqn{\sum_{i\in S} 2^{i-1}}.
}
\examples{
N <- c(1:5)
S <- c(1, 2, 3)
getcoalitionnumber(S)
n <- length(N) # number of players
NS <- setdiff(N,S) # complementary coalition
getcoalitionnumber(S) + getcoalitionnumber(NS) == 2^n - 1
}
\seealso{
\link{codebin2lex}, \link{codelex2bin}, \link{getcoalition}
}
