% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TangledFeatures.R
\name{TangledFeatures}
\alias{TangledFeatures}
\title{The main TangledFeatures function}
\usage{
TangledFeatures(
  Data,
  Y_var,
  Focus_variables = list(),
  corr_cutoff = 0.7,
  RF_coverage = 0.95,
  plot = FALSE,
  fast_calculation = FALSE,
  cor1 = "pearson",
  cor2 = "polychoric",
  cor3 = "spearman"
)
}
\arguments{
\item{Data}{The imported Data Frame}

\item{Y_var}{The dependent variable}

\item{Focus_variables}{The list of variables that you wish to give a certain bias to in the correlation matrix}

\item{corr_cutoff}{The correlation cutoff variable. Defaults to 0.8}

\item{RF_coverage}{The Random Forest coverage of explainable. Defaults to 95 percent}

\item{plot}{Return if plotting is to be done. Binary True or False}

\item{fast_calculation}{Returns variable list without many Random Forest iterations by simply picking a variable from a correlated group}

\item{cor1}{The correlation metric between two continuous features. Defaults to pearson correlation}

\item{cor2}{The correlation metric between one categorical feature and one continuous feature. Defaults to bi serial correlation correlation}

\item{cor3}{The correlation metric between two categorical features. Defaults to Cramer's V.}
}
\value{
Returns a list of variables that are ready for future modelling, along with other metrics
}
\description{
The main TangledFeatures function
}
\examples{
TangledFeatures(Data = TangledFeatures::Advertisement, Y_var = 'Sales')
}
