% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micePMM.r
\name{micePMM}
\alias{micePMM}
\title{Predictive mean matching (PMM)}
\usage{
micePMM(test.data, Mvalue = "NA")
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}
}
\value{
A data frame with all missing responses replaced by integrated imputed values.
}
\description{
This function imputes for all missing responses using predictive mean matching. 
The mice () function with default settings from the mice package (Van Buuren & Groothuis-Oudshoorn, 2011 
<doi: 10.18637/jss.v045.i03>) is used to impute for the missing responses.
}
\examples{
 
        micePMM(test.data, Mvalue="NA")
}
\references{
{
Van Buuren, S., & Groothuis-Oudshoorn, K. (2011).
"mice: Multivariate imputation by chained equations in R."
 Journal of statistical software, 45(1), 1-67. DOI: 10.18637/jss.v045.i03.
}
}
