% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadItemPool}
\alias{loadItemPool}
\title{Load item pool}
\usage{
loadItemPool(ipar, ipar_se = NULL, unique = FALSE)
}
\arguments{
\item{ipar}{item parameters. Can be a \code{\link{data.frame}} or the file path of a .csv file. The content should at least include columns 'ID' and 'MODEL'.}

\item{ipar_se}{(optional) standard errors. Can be a \code{\link{data.frame}} or the file path of a .csv file.}

\item{unique}{if \code{TRUE}, item IDs must be unique to create a valid \code{\linkS4class{item_pool}} object. (default = \code{FALSE})}
}
\value{
\code{\link{loadItemPool}} returns an \code{\linkS4class{item_pool}} object.

\itemize{
  \item{\code{ni}} the number of items in the pool.
  \item{\code{max_cat}} the maximum number of response categories across all items in the pool.
  \item{\code{index}} the numeric item index of each item.
  \item{\code{id}} the item ID string of each item.
  \item{\code{model}} the object class names of each item representing an item model type.
  Can be \code{\linkS4class{item_1PL}}, \code{\linkS4class{item_2PL}}, \code{\linkS4class{item_3PL}},
  \code{\linkS4class{item_PC}}, \code{\linkS4class{item_GPC}}, or \code{\linkS4class{item_GR}}.
  \item{\code{NCAT}} the number of response categories of each item.
  \item{\code{parms}} a list containing the item object of each item.
  \item{\code{ipar}} a matrix containing all item parameters.
  \item{\code{se}} a matrix containing all item parameter standard errors. The values will be 0 if the argument \code{ipar_se} was not supplied.
  \item{\code{raw}} the original input \code{ipar} argument used to create this object.
  \item{\code{raw_se}} the original input \code{ipar_se} argument used to create this object.
  If the argument was not supplied, this will be in the same structure with the \code{ipar} argument but the item parameter values will be filled with 0s.
  \item{\code{unique}} the original input \code{unique} argument used to create this object.
}
}
\description{
\code{\link{loadItemPool}} is a data loading function for creating an \code{\linkS4class{item_pool}} object.
\code{\link{loadItemPool}} can read item parameters and standard errors from a \code{\link{data.frame}} or a .csv file.
}
\examples{
## Read from data.frame:
itempool_science <- loadItemPool(itempool_science_data)

## Read from file: write to tempdir() for illustration and clean afterwards
f <- file.path(tempdir(), "itempool_science.csv")
write.csv(itempool_science_data, f, row.names = FALSE)
itempool_science <- loadItemPool(f)
file.remove(f)

}
\seealso{
\code{\link{dataset_science}}, \code{\link{dataset_reading}}, \code{\link{dataset_fatigue}}, \code{\link{dataset_bayes}} for examples.
}
