% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotExposurePanel}
\alias{plotExposurePanel}
\title{(Internal) Draw an exposure rate plot}
\usage{
plotExposurePanel(
  item_exposure_rate,
  item_exposure_rate_final = NULL,
  stim_exposure_rate = NULL,
  stim_index = NULL,
  max_rate = max_rate,
  title = NULL,
  color = "blue",
  color_final = "yellow",
  color_stim = "red",
  color_threshold = "dark gray",
  simple = FALSE,
  ...
)
}
\arguments{
\item{item_exposure_rate}{exposure rates for each item.}

\item{item_exposure_rate_final}{exposure rates for each item, treating items administered in non-true segments as not exposed. Conceptually this will never exceed \code{item_exposure_rate}.}

\item{stim_exposure_rate}{exposure rates for each stimulus.}

\item{stim_index}{the stimulus index each item belongs to.}

\item{max_rate}{target exposure rate for each theta segment.}

\item{title}{the title of this plot panel.}

\item{color}{the color for exposure rate bars. (default = \code{blue})}

\item{color_final}{the color for exposure rate bars, treating items administered in non-true segments as not exposed. (default = \code{yellow})}

\item{color_stim}{the color for stimulus groupings. (default = \code{red})}

\item{color_threshold}{the color for the target exposure rate bar. (default = \code{dark gray})}

\item{simple}{not used.}

\item{...}{arguments to pass onto \code{\link{plot}}.}
}
\description{
\code{\link{plotExposurePanel}} is an internal function for
drawing an exposure rate plot for a single theta segment.
}
\keyword{internal}
