% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covMatCS.R
\name{covMatCS}
\alias{covMatCS}
\title{Generate a covariance matrix with equivariance-equicorrelation or compound symmetry structure.}
\usage{
covMatCS(p, sigma2 = 1, rho = NULL)
}
\arguments{
\item{p}{An integer specifying the number of dimensions of the covariance matrix.}

\item{sigma2}{A numeric value specifying the variance parameter (default = 1).}

\item{rho}{A numeric value specifying the correlation parameter. If not provided,
             a random value between 0 and 1 will be generated.


The compound symmetry structure is defined as follows:

\deqn{\Sigma = \Sigma_{CS} = \sigma^2 \begin{bmatrix}
1 & \rho & \cdots & \rho \\
\rho & 1 & \cdots & \rho \\
\vdots & \vdots & \ddots & \vdots \\
\rho & \rho & \cdots & \rho
\end{bmatrix}}
where \eqn{\Sigma } is the covariance matrix, \eqn{\sigma^2} is the variance parameter,
and \eqn{\rho } is the correlation parameter.}
}
\value{
A \eqn{p \times p} numeric matrix representing the covariance matrix with
equivariance-equicorrelation or compound symmetry structure.
}
\description{
This function generates a covariance matrix with equivariance-equicorrelation
}
\examples{
# generate a covariance matrix for \eqn{p = 5}, \eqn{\sigma^2 = 1}, and \eqn{\rho = 0.9}.
covMatCS(p = 5, rho = 0.9)

# generate a covariance matrix for \eqn{p = 5},  \eqn{\sigma^2 = 5}, and \eqn{\rho = 0.9}.
covMatCS(p = 5, sigma2 = 5, rho = 0.9)

# generate  covariance matrix for \eqn{p = 5},  and no value is considered for \eqn{\rho}
covMatCS(p = 5)

}
