% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_r_code.R
\name{extract_r_code}
\alias{extract_r_code}
\title{Extract R code and comments from a given input string.}
\usage{
extract_r_code(input_string)
}
\arguments{
\item{input_string}{A character string containing R code and comments, mixed with other text.
The string may contain multiple lines separated by newline characters.}
}
\value{
A character vector containing R code and comment lines extracted from the input string.
        Each element in the vector corresponds to one line of code or a comment.
}
\description{
This function takes an input string, detects R code and comments, and returns a character vector
containing the R code and comments. The input string is split into lines based on newline characters,
and each line is examined for R code and comment patterns. Only the lines that match either of these
patterns are returned.
}
\examples{
example_string <- 
"This is a text string with R code and comments.\n
# A comment\n
x <- 5\
ny = 10\n
z <- x + y\n
Another line of text."
extract_r_code(example_string)
}
