% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_file_extension.R
\name{replace_file_extension}
\alias{replace_file_extension}
\title{Replace File Extension}
\usage{
replace_file_extension(filename, new_extension)
}
\arguments{
\item{filename}{The input filename as a character string.}

\item{new_extension}{The new file extension to replace the old one (including the dot, e.g., ".bib").}
}
\value{
A character string representing the filename with the replaced file extension.
}
\description{
This function replaces the file extension of a given filename with a specified new extension.
It validates the input to ensure the filename and the new extension are single character strings.
Then, it replaces the old extension with the new one and returns the modified filename.
}
\examples{
\dontrun{
# Replace the file extension of a text file with a BibTeX extension
new_filename <- replace_file_extension("example_document.txt", ".bib")
print(new_filename) # "example_document.bib"
}
}
\author{
Ulrich Matter umatter@protonmail.com
}
