% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designA.R
\name{designA}
\alias{designA}
\title{Create the Thurstonian design matrix for paired comparison and ranking data.}
\usage{
designA(blocks = NULL, nitems = max(unique(blocks)))
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{nitems}{The number of items that are included in the design.}
}
\value{
Returns a design matrix which includes all paired comparisons
derivable from the blocks.
}
\description{
Creates the Thurstonian design matrix for paired comparison and ranking data,
given by blocks or the number of items.
}
\details{
Each Thurstonian design can be defined by blocks of at least two
items. The function determines the fundamental design matrix A of the
Thurstonian design, including all possible paired comparisons that can be
derived by the blocks. For further information of the importance of the
design matrix, see Jansen and Schulze (2023a,2023b).
}
\examples{

# Define a matrix of blocks
blocks <- matrix(1:15,ncol=3, byrow=TRUE)

# Get the design matrix
loading_Matrix <- designA(blocks)

}
\references{
Jansen, M. T., & Schulze, R. (2023a). \emph{Linear factor analytic Thurstonian forced-choice models: Current status and issues}. Manuscript submitted.

Jansen, M. T., & Schulze, R. (2023b). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.
}
