% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.xblocks.R
\name{get.xblocks}
\alias{get.xblocks}
\title{Get extra blocks in a Thurstonian design, that links all blocks.}
\usage{
get.xblocks(blocks, itf, multidim, item_not = NULL, min = FALSE,
  show.warnings = FALSE)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{multidim}{Logical. Should the items within each linking block be
forced to be multidimensional?}

\item{item_not}{The items that are differently keyed compared to the majority
of items.}

\item{min}{Logical. Should a minimal number of blocks contain mixed keyed items?}

\item{show.warnings}{Logical. Should warnings be shown?}
}
\value{
The result is a matrix where the rows correspond to the specific
extra blocks.
}
\description{
The function creates extra blocks for a Thurstonian design, that links all
initial blocks with as few extra blocks as possible. The number of extra
blocks is determined by `count.xblocks` (see Jansen & Schulze, 2023).
}
\examples{

# Define a matrix of blocks
blocks <- matrix(1:15,ncol=3, byrow=TRUE)

# define the item-to-factor relation
itf <- rep(1:3,5)
 
# Get the extra blocks for a completely linked design
get.xblocks(blocks, itf, FALSE)

}
\references{
Jansen, M. T., & Schulze, R. (2023). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.
}
