% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-negative-binomial.R
\name{tidy_negative_binomial}
\alias{tidy_negative_binomial}
\title{Tidy Randomly Generated Negative Binomial Distribution Tibble}
\usage{
tidy_negative_binomial(
  .n = 50,
  .size = 1,
  .prob = 0.1,
  .num_sims = 1,
  .return_tibble = TRUE
)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.size}{target for number of successful trials, or dispersion parameter
(the shape parameter of the gamma mixing distribution). Must be strictly
positive, need not be integer.}

\item{.prob}{Probability of success on each trial where 0 < .prob <= 1.}

\item{.num_sims}{The number of randomly generated simulations you want.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a negative binomial
distribution with a user provided, \code{.size}, \code{.prob}, and number of
random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{d_}, \code{p_} and \code{q_} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{stats::rnbinom()}, and its underlying
\code{p}, \code{d}, and \code{q} functions. For more information please see \code{\link[stats:NegBinomial]{stats::rnbinom()}}
}
\examples{
tidy_negative_binomial()

}
\seealso{
\url{https://openacttexts.github.io/Loss-Data-Analytics/ChapSummaryDistributions.html}

Other Discrete Distribution: 
\code{\link{tidy_bernoulli}()},
\code{\link{tidy_binomial}()},
\code{\link{tidy_geometric}()},
\code{\link{tidy_hypergeometric}()},
\code{\link{tidy_poisson}()},
\code{\link{tidy_zero_truncated_binomial}()},
\code{\link{tidy_zero_truncated_negative_binomial}()},
\code{\link{tidy_zero_truncated_poisson}()}

Other Binomial: 
\code{\link{tidy_binomial}()},
\code{\link{tidy_zero_truncated_binomial}()},
\code{\link{tidy_zero_truncated_negative_binomial}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_binomial_stats_tbl}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_zero_truncated_binomial_param_estimate}()},
\code{\link{util_zero_truncated_binomial_stats_tbl}()},
\code{\link{util_zero_truncated_negative_binomial_param_estimate}()},
\code{\link{util_zero_truncated_negative_binomial_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Binomial}
\concept{Discrete Distribution}
\concept{Negative Distribution}
