% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-helpers-visualization.R
\name{plot_zones_static}
\alias{plot_zones_static}
\title{Generate static plot of polygons on a map}
\usage{
plot_zones_static(
  polygons,
  coastline,
  title,
  colors,
  show_legend = TRUE,
  name_legend = NULL,
  labels = NULL,
  add_grid = TRUE,
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{polygons}{List of polygons. Each polygon must contain a coords matrix with longitude and latitude columns.}

\item{coastline}{Data frame with the coastline, with columns Long and Lat.}

\item{title}{Main title of the plot.}

\item{colors}{Vector of colors to fill the polygons. If NULL, colors are automatically assigned by groups.}

\item{show_legend}{Logical. If TRUE, the legend is displayed.}

\item{name_legend}{Name of the legend (optional). If NULL, legend has no title.}

\item{labels}{Vector of labels for the polygons (optional).}

\item{add_grid}{Logical. If TRUE, adds a geographic grid to the plot.}

\item{theme}{ggplot2 theme to use.}
}
\value{
A ggplot object ready to be plotted.
}
\description{
Creates a static plot using ggplot2 that displays geographic polygons on a coastline base.
Colors are assigned by groups (announcements/labels), not individual polygons.
}
\keyword{internal}
