% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonMar.R
\name{ADMM}
\alias{ADMM}
\title{ADMM algorithm for weighted classification}
\usage{
ADMM(X,ybar,Weight,Covariate=NULL,r,srow,scol,lambda=0,rho.ini=1)
}
\arguments{
\item{X}{A list of matrix-valued predictors.}

\item{ybar}{A vector of  shifted response variables.}

\item{Weight}{Classification weight.}

\item{Covariate}{Additional covariates including intercept. \code{Covariate = NULL} indicates no covariates.}

\item{r}{The rank of coefficient matrix to be fitted.}

\item{srow}{The number of zero rows in coefficient matrix.}

\item{scol}{The number of zero columns in coefficient matrix.}

\item{lambda}{Lagrangian multiplier. Default is zero.}

\item{rho.ini}{Initial step size. Default is 1.}
}
\value{
The returned object is a list of components.

\code{intercept} - The estimated intercept of the classifier.

\code{P_row} - The left-singular vectors of the coefficient matrix.

\code{P_col} - The right-singular vectors of the coefficient matrix.

\code{obj} - Trajectory of weighted classification loss values over iterations.

\code{iter} - The number of iterations.

\code{fitted} - A vector of fitted reponse from estimated classifier.

\code{B} - The estimated coefficient matrix of the classifier.
}
\description{
Implement an ADMM algorithm to optimize the weigthed classificiation loss.
}
\examples{
#### Generate matrix predictors  ##########
X = list()
for(i in 1:10){
 X[[i]] = matrix(runif(4,-1,1),nrow = 2,ncol = 2)
}

#### Generate coefficient matrix #########
B = runif(2,-1,1)\%*\%t(runif(2,-1,1))

#### Generate response variables #########
y = NULL
for(i in 1:10){
 y = c(y,sign(sum(X[[i]]*B)+rnorm(1,sd = 0.1)))
}

#### classification with equal weights #########
res = ADMM(X,y,rep(1,10),r = 1,srow = 0,scol = 0)

### Misclassification rate on training data ######
mean(sign(res$fitted)-y)
}
\references{
Lee, C., Li, L., Zhang, H., and Wang, M. (2021). Nonparametric Trace Regression via Sign Series Representation. \emph{arXiv preprint arXiv:2105.01783}.
}
