% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonMar.R
\name{TraceAssist}
\alias{TraceAssist}
\title{Aggregation of structured sign series for trace regression (ASSIST)}
\usage{
TraceAssist(X,y,X_new=NULL,r,sparse_r,sparse_c,H=10,lambda=0,rho.ini=0.1,min,max)
}
\arguments{
\item{X}{A list of matrix-valued predictors.}

\item{y}{A vector of response variables.}

\item{X_new}{A list of new matrices in the test data. \code{X_new = NULL} returns fitted values in the training data.}

\item{r}{The rank of sign representable function to be fitted.}

\item{sparse_r}{The number of zero rows in coefficient matrix.}

\item{sparse_c}{The number of zero columns in coefficient matrix.}

\item{H}{Resoution parameter that controls the number of classifiers to aggregate.}

\item{lambda}{Lagrangian multiplier.}

\item{rho.ini}{Initial step size.}

\item{min}{Minimum value of the response variables}

\item{max}{Maximum value of the response variables.}
}
\value{
The returned object is a list of components.

\code{B_est} - An array that collects a series of coefficient matrices for the classifiers used in the algorithm.

\code{fitted} - The predicted responses in the test data.

\code{sign_fitted} - A matrix that collects a series of predicted signs for the classifiers used in the algorithm.
}
\description{
Main function for fitting the nonparametric trace regression. The algorithm uses a learning reduction approach to estimate the nonparametric trace regression via ASSIST.
}
\examples{
######### Generate matrices in the training data ################
X = list()
for(i in 1:10){
 X[[i]] = matrix(runif(4,-1,1),nrow = 2,ncol = 2)
}

######### Generate coefficient matrix ###########################
B = runif(2,-1,1)\%*\%t(runif(2,-1,1))

######### Generate response variables ###########################
y = NULL;signal = NULL
for(i in 1:10){
 signal = c(signal,sum(X[[i]]*B))
 y = c(y,sum(X[[i]]*B)+rnorm(1,sd = 0.1))
}


######### Run ASSIST ############################################
res =TraceAssist(X,y,r = 1,sparse_r = 0,sparse_c = 0,min = min(y),max = max(y))
mean(abs(res$fitted-signal))


######### Generate new matrices in the test data ################
X_new = list()
for(i in 1:10){
  X_new[[i]] = matrix(runif(4,-1,1),nrow = 2,ncol = 2)
}

######### Generate response variables from X_new ################
y_new = NULL
for(i in 1:10){
  y_new = c(y_new,sum(X_new[[i]]*B))
}

######### Run ASSIST #############################################
res =TraceAssist(X,y,X_new,r = 1,sparse_r = 0,sparse_c = 0,min = min(y),max = max(y))
mean(abs(res$fitted-y_new))

}
\references{
Lee, C., Li, L., Zhang, H., and Wang, M. (2021). Nonparametric Trace Regression via Sign Series Representation. \emph{arXiv preprint arXiv:2105.01783}.
}
