% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPCfunctions.R
\name{TPC}
\alias{TPC}
\title{Gaussian-Quadratic Function Thermal Performance Curve}
\usage{
TPC(T_b, T_opt, CT_min, CT_max)
}
\arguments{
\item{T_b}{\code{numeric} vector of temperature range (C).}

\item{T_opt}{\code{numeric} thermal optima (C), the temperature at which peak performance occurs.}

\item{CT_min, CT_max}{\code{numeric} critical thermal minimum and maximum (C), the lower and upper temperature limits for performance.}
}
\value{
performance
}
\description{
The function constructs a thermal performance curve by combining as a Gaussian function to describe the rise in performance up to the optimal temperature and a quadratic decline to zero performance at critical thermal maxima and higher temperatures \insertCite{Deutsch2008}{TrenchR}.
}
\examples{
  TPC(T_b    = 0:60, 
      T_opt  = 30, 
      CT_min = 10, 
      CT_max = 40)

}
\references{
\insertAllCited{}
}
