% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series2.R
\name{Series2}
\alias{Series2}
\title{Tri-Hierarchical IBDs using Latin Square Association Scheme}
\usage{
Series2(
  v,
  D1 = FALSE,
  D2 = FALSE,
  D3 = FALSE,
  D4 = FALSE,
  D5 = FALSE,
  D6 = FALSE,
  Randomization = FALSE
)
}
\arguments{
\item{v}{Number of treatments, v (>=16) should be a square number}

\item{D1}{Bi-Hierarchical IBD by ignoring blocks}

\item{D2}{Bi-Hierarchical IBD by ignoring sub-blocks}

\item{D3}{Bi-Hierarchical IBD by ignoring sub-sub blocks}

\item{D4}{IBD at block level}

\item{D5}{IBD at sub block level}

\item{D6}{IBD at sub-sub block level}

\item{Randomization}{Randomization of layout of the designs if needed enter TRUE; by default it is FALSE.}
}
\value{
It gives Tri-HIB design and six component designs with canonical efficiency factor in comparison to an orthogonal design.
}
\description{
It generates the Tri-Hierarchical IBDs based on Latin Square association scheme. Here, number of treatments (v) should be a perfect square. We find balanced incomplete block designs (BIBD) at block level and latin square PBIB designs at sub-block level as well as sub-sub block level. Information matrix pertaining to the estimation of treatments effects, canonical efficiency factor in comparison to an orthogonal design and six component designs are provided.
}
\note{
Numbers in the outer most parentheses represents as block elements, second level parentheses as sub block elements and inner most parentheses as sub-sub block elements.
}
\examples{
library(Tri.Hierarchical.IBDs)
Series2(16,D1=TRUE,D2=TRUE,D3=FALSE,D4=FALSE,D5=FALSE,D6=FALSE,Randomization=FALSE)
}
\references{
Preece, D.A. (1967) <https://doi.org/10.1093/biomet/54.3-4.479>."Nested balanced incomplete block designs".
}
