% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_cells.R
\name{define_cells}
\alias{define_cells}
\title{Define Cells}
\usage{
define_cells(Rasterdomain, name = "Problem")
}
\arguments{
\item{Rasterdomain}{A Raster object with any value in the cells that are part of the problem and NA values where the problem is not to be solved}

\item{name}{The name of the output file}
}
\value{
.dat file. This function is used for the side-effect of writing values to a file.
}
\description{
This function takes a Raster object and identifies non NA cells and writes them to a .dat file. The file
will be written to the location specified by the \code{name} argument. If the file
already exists, it will be overwritten. The file format is plain text, with each
line terminated by a newline character.
}
\examples{
data(Species)
library(terra)
Test <- Species[[1]] |>
terra::unwrap()

# Generate the "Problem.dat" file

define_cells(Test[[1]])

file.remove("Problem.dat")

}
\author{
Derek Corcoran
}
