% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_landuse_suitability.R
\name{species_suitability_landuse}
\alias{species_suitability_landuse}
\title{Calculate species suitability for each landuse}
\usage{
species_suitability_landuse(
  Rasterspecieslanduse,
  species_names,
  landuses,
  name = "Problem",
  verbose = FALSE
)
}
\arguments{
\item{Rasterspecieslanduse}{a list of species suitability for each landuse}

\item{species_names}{character vector of species names}

\item{landuses}{character vector with all landuses}

\item{name}{The name of the output file}

\item{verbose}{Logical whether messages will be written while the
function is generating calculations, defaults to FALSE}
}
\value{
.dat file. This function is used for the side-effect of writing values to a file.
}
\description{
Calculate species suitability from a given raster, species names and landuse and writes them to a .dat file. The file
will be written to the location specified by the \code{name} argument. If the file
already exists, it will be overwritten. The file format is plain text, with each
line terminated by a newline character.
}
\examples{
library(terra)
data("Species_Landuse")
Species_Landuse <- Species_Landuse |> purrr::map(terra::unwrap)
species_suitability_landuse(Rasterspecieslanduse = Species_Landuse,
species_names = c("Spp1", "Spp2", "Spp3", "Spp4"),
landuses = c("Agriculture", "Forest", "Urban"), name = "Test")
file.remove("Test.dat")

}
