% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trueskillthroughtime.R
\name{Gaussian}
\alias{Gaussian}
\alias{Pi}
\alias{Pi,Gaussian-method}
\alias{Tau}
\alias{Tau,Gaussian-method}
\alias{forget}
\alias{forget,Gaussian,numeric,numeric-method}
\alias{isapprox}
\alias{isapprox,Gaussian,Gaussian,numeric-method}
\alias{+,Gaussian,Gaussian-method}
\alias{-,Gaussian,Gaussian-method}
\alias{*,Gaussian,Gaussian-method}
\alias{/,Gaussian,Gaussian-method}
\alias{==,Gaussian,Gaussian-method}
\alias{performance,Player-method}
\title{Gaussian}
\usage{
Gaussian(mu = 0, sigma = 1)

Pi(N)

\S4method{Pi}{Gaussian}(N)

Tau(N)

\S4method{Tau}{Gaussian}(N)

forget(N, gamma, t)

\S4method{forget}{Gaussian,numeric,numeric}(N, gamma, t)

isapprox(N, M, tol = 1e-04)

\S4method{isapprox}{Gaussian,Gaussian,numeric}(N, M, tol = 1e-04)

\S4method{+}{Gaussian,Gaussian}(e1, e2)

\S4method{-}{Gaussian,Gaussian}(e1, e2)

\S4method{*}{Gaussian,Gaussian}(e1, e2)

\S4method{/}{Gaussian,Gaussian}(e1, e2)

\S4method{==}{Gaussian,Gaussian}(e1, e2)

\S4method{performance}{Player}(a)
}
\arguments{
\item{mu}{A number, the mean of the Gaussian distribution.}

\item{sigma}{A number, the standar deviation of the Gaussian distribution.}

\item{N}{A Gaussian object}

\item{gamma}{The dynamic factor, the dynamic uncertainty}

\item{t}{The elapsed time}

\item{M}{A Gaussian object}

\item{tol}{The tolerance threshold for comparitions}

\item{e1}{A Gaussian object}

\item{e2}{A Gaussian object}

\item{a}{A Gaussian object}
}
\value{
Gaussian object
}
\description{
Gaussian class
}
\examples{
N01 = Gaussian(0,1); N12 = Gaussian(mu = 1, sigma = 2)
N06 = Gaussian(); Ninf = Gaussian(0,Inf)
N01 * Ninf == N01
N01 * N12
N01 / N12
N01 + N12
N01 - N12
Pi(N12) == 1/(N12@sigma^2)
Tau(N12) == N12@mu/(N12@sigma^2)
Nnew = forget(N = N01, gamma = 0.01, t = 100)
isapprox(Nnew, Gaussian(N01@mu,sqrt(N01@sigma^2+100*(0.01^2))), tol=1e-6)

}
