% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{TEST.diffvar}
\alias{TEST.diffvar}
\title{Tests on variances}
\usage{
TEST.diffvar(
  x,
  y,
  by,
  digits = 2,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x, y}{Unquoted strings identifying the \emph{numeric}
variables with the same length whose variances have to be compared.
\code{x} and \code{y} can be the names of vectors in the workspace
or the names of columns in the data frame
specified in the \code{data} argument. It is possible to
use a mixed specification (e.g, one vector and one
column in data).}

\item{by}{Optional unquoted string identifying a variable
(of any type), defined same way as \code{x},
taking only \bold{two} values used to split
\code{x} into two independent samples. Since the
null hypothesis of equal variances is tested against the
bilateral alternative only, the order of the levels of
\code{by} is irrelevant (differently from what holds
for functions building confidence intervals or testing
hypotheses on the differences between means or proportions).
Note that only \bold{one} between \code{y} and \code{by} can be
specified.}

\item{digits}{Integer value specifying the number of
decimals used to round statistics; default to 2. If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether reported values
should be forcedly rounded to the number of decimals specified in
\code{digits} even if non-zero values are
rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x} and/or
\code{y}. If not found in \code{data}, the variables
are taken from the environment
from which \code{TEST.diffvar()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table reporting the results of the test on the
difference between the variances of two independent populations.
}
\description{
\code{TEST.diffvar()} tests the hypothesis of equality between the
variances of two independent populations.
}
\examples{
data(MktDATA, package = "UBStats")

# Using x,y: build vectors with data on the two groups
AOV_M <- MktDATA$AOV[MktDATA$Gender == "M"]
AOV_F <- MktDATA$AOV[MktDATA$Gender == "F"]
TEST.diffvar(x = AOV_M, y = AOV_F)
TEST.diffvar(x = AOV_F, y = AOV_M) # same

# Using x,by: groups identified by ordered levels of by
TEST.diffvar(x = AOV, by = Gender, data=MktDATA)

# Output results
out_test.diffV<-TEST.diffvar(x = AOV_M, y = AOV_F)

# Arguments force.digits and use.scientific
#  An input variable taking very low values
SmallX<-MktDATA$AOV/50000
SmallX_M <- SmallX[MktDATA$Gender == "M"]
SmallX_F <- SmallX[MktDATA$Gender == "F"]
#  - Default output
TEST.diffvar(x = SmallX_M, y = SmallX_F)
#  - Request to use the exact number of digits (default, 2)
TEST.diffvar(x = SmallX_M, y = SmallX_F,
             force.digits = TRUE)
#  - Request to allow scientific notation
TEST.diffvar(x = SmallX_M, y = SmallX_F, 
             use.scientific = TRUE)

}
\seealso{
\code{\link{CI.diffmean}()} to build confidence intervals for
the difference between two populations' means.

\code{\link{TEST.diffmean}()} to test hypotheses on the difference
between two populations' means.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
