% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{app_run2}
\alias{app_run2}
\title{Run UCSC Xena Shiny App with specifc content}
\usage{
app_run2(
  runMode = "client",
  port = getOption("shiny.port"),
  content = c("a", "s", "q", "p", "d")
)
}
\arguments{
\item{runMode}{default is 'client' for personal user, set it to 'server' for running on server.}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}

\item{content}{Modules to enable.
\itemize{
\item \code{a}: all modules
\item \code{s}: only loading basic modules;
\item \code{q}: add tpc (TCGA, PCAWG, CCLE) modules
\item \code{p}: add tpc pipelines
\item \code{d}: add pharmcogenomics modules
}}
}
\description{
Run UCSC Xena Shiny App with specifc content
}
\examples{
\dontrun{
app_run2(content = "s")
}
}
