% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Drilldown.R
\name{Plot.Drilldown}
\alias{Plot.Drilldown}
\title{Cree un gráfico profundo (\emph{drill down}) de torta/barras dinámico y flexible}
\usage{
Plot.Drilldown(
  datos,
  varPrincipal,
  varSecundaria,
  ano,
  periodo,
  torta = TRUE,
  vertical = TRUE,
  colores,
  colores2,
  titulo = "",
  label = "",
  textInfo = "",
  addPeriodo = TRUE,
  estilo = NULL
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{varPrincipal}{Una variable categórica dentro del data frame ingresado
en \code{datos}.}

\item{varSecundaria}{Otra variable categórica dentro del data frame ingresado
en \code{datos}, diferente a la principal, pues se segregará a otros niveles.}

\item{ano}{Igual uso que en \code{\link[=Plot.Torta]{Plot.Torta()}}}

\item{periodo}{Igual uso que en \code{\link[=Plot.Torta]{Plot.Torta()}}}

\item{torta}{Si es \code{TRUE} (\emph{valor predeterminado}) el primer nivel o gráfico
principal será un diagrama de torta, defínalo en \code{FALSE} si desea que éste
sea un gráfico de barras.}

\item{vertical}{Si es \code{TRUE} (\emph{valor predeterminado}) indicará que tanto la
orientación del gráfico principal como secundario será vertical. Solamente
aplicará si el argumento \code{torta} es \code{FALSE}.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las trazas correspondiente a cada nivel del
argumento \code{varPrincipal}. Si no se introduce algún vector se usará la paleta
\code{rainbow} por defecto.}

\item{colores2}{Igual que \code{colores} pero aplicado al gráfico secundario.}

\item{titulo}{Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}}

\item{label}{Cadena de caracteres indicando el agregado al que hace referencia
el gráfico. Por defecto no se emplea ningún rótulo.}

\item{textInfo}{Cadena de caracteres indicando el texto que aparecerá dentro
de la caja de información al pasar el mouse por las diferentes columnas del
gráfico de barras.}

\item{addPeriodo}{Igual uso que en \code{\link[=Plot.Torta]{Plot.Torta()}}}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
para graficar el drill down y cuyo objetivo es personalizar pequeños detalles
de éste.
\itemize{
\item \code{LegendTitle}: Cadena de caracteres indicado un título para la leyenda
(\emph{diferentes niveles del argumento \code{varPrincipal}}).
\item \code{hc.Tema} y \code{hc.Credits}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
}}
}
\value{
Retorna el diagrama drill down (\emph{objeto widget de HTML}) creado. La clase del
objeto retornado será un "htmlwidget" y adicionalmente pertenecerá a la clase
"highchart".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de un gráfico drill down con el objetivo de poder inspeccionar los datos con
mayor nivel de detalle, sin la necesidad de navegar o salir de él, pudiendo
hacer clic en diversos elementos como columnas o sectores circulares. Dicha
gráfica se va a representar usando la librería \code{Highcharter}, la cual usa
internamente \code{JavaScript}.
}
\examples{
\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# library(dplyr)
df <- ejMiniConsolidadoAsp |>
  filter(Clase != "Sin Información", tolower(Clase) != "no aplica")
text <- "DISTRIBUCI\u00d3N DE ASPIRANTES A PREGRADO EN SITUACI\u00d3N DE DISCAPACIDAD"
Msj  <- paste(
  "Discapacidad: Deficiencia, limitaci\u00f3n de la actividad ",
  "y la restricci\u00f3n de la participaci\u00f3n."
)
Plot.Drilldown(
  datos         = df,
  varPrincipal  = "DISCAPACIDAD",
  varSecundaria = "TIPO_DISC",
  ano           = max(df$YEAR),
  periodo       = slice(df, n())$SEMESTRE,
  torta         = TRUE, # Pruebe poniendo ambos valores ahora en FALSE
  vertical      = TRUE,
  colores       = c("#FF0040", "#00FF40"),
  colores2      = c("#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F"),
  titulo        = text,
  label         = "Aspirantes",
  textInfo      = "Aspirantes con discapacidades por tipo",
  addPeriodo    = TRUE,
  estilo        = list(hc.Tema = 7, hc.Credits = Msj)
)
\dontshow{\}) # examplesIf}
}
