% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCMC_LOGIT_KEEP}
\alias{MCMC_LOGIT_KEEP}
\title{Obtains posterior samples from an MCMC algorithm to perform variable selection.}
\usage{
MCMC_LOGIT_KEEP(Y, Z, PIN, MAX_COV, SdBeta, NUM_REPS)
}
\arguments{
\item{Y}{Binary outcome vector.}

\item{Z}{Matrix of covariates including binary exposure variable.}

\item{PIN}{Prior probability of inclusion of candidate variables.}

\item{MAX_COV}{Maximum number of covariates in desired model.}

\item{SdBeta}{Prior standard deviation for generating distrubtion of proposal coefficients.}

\item{NUM_REPS}{Number of MCMC iterations to perform.}
}
\value{
List containing (1) the posterior distribution of the estimated Average Treatment Effect, (2) the
        posterior distributions of the intercept parameter, (3) the posterior distributions of the rest of the
        coefficients including the exposure coefficient, and (4) the posterior distribution for the indication
        of whether or not the variable was included in a given iteration's model.
}
\description{
Performs posterior sampling from an MCMC algorithm to estimate average treatment effect and posterior probability of
inclusion of candidate variables.
}
