% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_pipe_steps.R
\name{print_pipe_steps}
\alias{print_pipe_steps}
\title{Prints the return objects of all pipe steps to console}
\usage{
print_pipe_steps(.data, cmd = print_command, all = FALSE)
}
\arguments{
\item{.data}{The data, normally handed over from the prior pipe step.}

\item{cmd}{The command to be evaluated for each object. Takes ps%d as placeholder for
object of step  %d and title for the title of the view. See below for an
example.}

\item{all}{Whether you want to print objects even if they are identical. Helpful
when you want to display changes in grouping.}
}
\value{
The unchanged data
}
\description{
Added as last command to a pipe, prints for each pipe step the resulting
  object to the console if unique. Data frames are converted by as_tibble().
}
\examples{
\donttest{
if (!require(dplyr)) stop("Examples need dplyr to run")
mtcars \%>\%
  filter(am == 1) \%>\%
  select(qsec) \%>\%
  print_pipe_steps() -> result

my_print_cmd <- c(
  "message(title);",
  "skimr::skim_tee(data = ps\%d)"
)

mtcars \%>\%
  select(am, hp, mpg) \%>\%
  group_by(am) \%>\%
  print_pipe_steps(my_print_cmd, all = TRUE) \%>\%
  summarize(
    nobs = n(),
    mean_hp = mean(hp),
    mean_mpg = mean(mpg)
  )
}
}
