% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeViralStats.R
\name{SummarizeViralStats}
\alias{SummarizeViralStats}
\title{SummarizeViralStats: Generate summary stats outside of plot functions}
\usage{
SummarizeViralStats(
  file,
  groupby = "best_query",
  metric,
  metric_cutoff,
  filter_cutoff = NULL,
  show_total = FALSE,
  extra_stats = NULL,
  sort_by = NULL,
  top_n = NULL,
  group_unwanted_phyla = NULL
)
}
\arguments{
\item{file}{VirusHunterGatherer hittable.}

\item{groupby}{(optional): A character specifying the column containing the groups (default: "best_query").
Note: Gatherer hittables do not have a "best_query" column. Please provide an appropriate column for grouping.}

\item{metric}{A character string specifying the name of the metric column to be used for calculations.
This column must be present in \code{file}. Supported metric columns include:
\itemize{
\item "contig_len"
\item "ViralRefSeq_E"
\item "ViralRefSeq_ident"
}}

\item{metric_cutoff}{A numeric value used to classify the metric into two categories: below cutoff and above or equal to cutoff.}

\item{filter_cutoff}{A numeric value for optional filtering of the data based on E-value. Rows where the specified filtering column has a value
less than this cutoff are retained. If \code{NULL}, no filtering is applied. Default is \code{NULL}.}

\item{show_total}{A logical value indicating whether to include a row with the total sums for each column in the summary table.
Default is \code{FALSE}.}

\item{extra_stats}{A character vector specifying additional summary statistics to include in the output. Options include:
\itemize{
\item \code{"mean"}
\item \code{"median"}
\item \code{"Q1"}
\item \code{"Q3"}
\item \code{"sd"}
\item \code{"min"}
\item \code{"max"}
}
If \code{NULL} (the default), only the basic counts are included.}

\item{sort_by}{(optional): A character string specifying the column name by which to sort the results.
Supported values include:
\itemize{
\item "less_than_X": The count of observations below the specified \code{metric_cutoff} (X is replaced by the cutoff value).
\item "equal_or_more_than_X": The count of observations greater than or equal to the specified \code{metric_cutoff} (X is replaced by the cutoff value).
\item "total": The total count of observations in each group.
\item "mean": The mean value of the specified metric in each group (if \code{"mean"} is included in \code{extra_stats}).
\item "median": The median value of the specified metric in each group (if \code{"median"} is included in \code{extra_stats}).
\item "Q1": The first quartile (25th percentile) of the specified metric in each group (if \code{"Q1"} is included in \code{extra_stats}).
\item "Q3": The third quartile (75th percentile) of the specified metric in each group (if \code{"Q3"} is included in \code{extra_stats}).
\item "sd": The standard deviation of the specified metric in each group (if \code{"sd"} is included in \code{extra_stats}).
\item "min": The minimum value of the specified metric in each group (if \code{"min"} is included in \code{extra_stats}).
\item "max": The maximum value of the specified metric in each group (if \code{"max"} is included in \code{extra_stats}).
}
If \code{NULL} (the default), no sorting is applied.}

\item{top_n}{(optional): A numeric value indicating the number of top rows to return based on the selected metric.
If \code{NULL} (the default), all rows are returned.}

\item{group_unwanted_phyla}{(optional): A character string specifying which group of viral phyla to retain in the analysis.
Valid values are:
\describe{
\item{"rna"}{Retain only the phyla specified for RNA viruses.}
\item{"smalldna"}{Retain only the phyla specified for small DNA viruses.}
\item{"largedna"}{Retain only the phyla specified for large DNA viruses.}
\item{"others"}{Retain only the phyla that match small DNA, Large DNA and RNA viruses.}
}
All other phyla not in the specified group will be grouped into a single category:
"Non-RNA-virus" for \code{"rna"}, "Non-Small-DNA-Virus" for \code{"smalldna"},"Non-Large-DNA-Virus" for \code{"largedna"},or "Other Viruses" for \code{"others"}.}
}
\value{
A data frame summarizing the viral stats. The output includes:
\itemize{
\item The count of observations below and above or equal to the \code{metric_cutoff}.
\item Optional additional summary statistics as specified by \code{extra_stats}.
\item An optional total row if \code{show_total} is \code{TRUE}.
}
}
\description{
Summarizes data by grouping it according to a specified metric (contig length, E-value or Identity).
SummarizeViralStats generates a summary table that includes counts of observations based on a specified metric cutoff.
It computes relevant summary statistics depending on the selected metric, with options to filter rows
based on a cutoff value.
}
\examples{
path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
file <- ImportVirusTable(path)

stats <- SummarizeViralStats(file=file,
groupby = "best_query",
metric = "ViralRefSeq_ident",
metric_cutoff = 90,
show_total = TRUE,
filter_cutoff = 1e-5,
extra_stats = c("median","Q1","Q3"))

print(stats)



}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
