\name{rdata_Lorenz}
\alias{rdata_Lorenz}
\title{Data set generated via the Lorenz system and used to exemplify the functions contained in \emph{VisualDom} 
}
\description{
The data set \code{\link{rdata_Lorenz}} contains four columns: the first column is time (unitless) and the following three columns are the X, Y, Z components of the Lorenz system. The Lorenz system consists of three coupled first-order ordinary differential equations and is without a doubt one of the most famous nonlinear dynamical mathematical models, and represents a paradigmatic example for both theoretical and numerical investigations in checking some results in chaos theory (Polanco-Martínez 2022). For more details on how the \code{\link{rdata_Lorenz}} was created see Polanco-Martínez (2023). 
}
\usage{data(rdata_Lorenz)
}
\format{One file in ASCII format containing 4 columns and 500 rows, columns are separated by spaces. 
}
\source{
Fernández-Macho, J. (2018). Time-localized wavelet multiple regression and correlation. Physica A: Statistical Mechanics and its Applications, 492, 1226-1238. <URL: \doi{10.1016/j.physa.2017.11.050}>. \cr 

Polanco-Martínez, J. M., Fernández-Macho, J., & Medina-Elizalde, M. (2020). Dynamic wavelet correlation analysis for multivariate climate time series. Scientific Reports, 10(1), 1-11. <URL: \doi{10.1038/s41598-020-77767-8}>. \cr 

Polanco-Martínez, J.M. (2023, in press), A computational and graphical approach to analyze the dynamic wavelet correlation among components of a nonlinear dynamical system, Journal of Applied Nonlinear Dynamics, 1-13. \cr 
}
\keyword{rdata_Lorenz}
\keyword{rdataset_Lorenz}
