% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transition_matrix.R
\name{convert_names}
\alias{convert_names}
\title{convert_names}
\usage{
convert_names(new_row, new_col, transition_matrix)
}
\arguments{
\item{new_row}{Vector with the new row names to assign to \emph{transition_matrix}}

\item{new_col}{Vector with the new column names to assign to \emph{transition_matrix}}

\item{transition_matrix}{Output from \emph{get_transition_matrix}.}
}
\value{
A matrix with row names equal to \emph{new_row} and column names equal to
\emph{new_col}.
}
\description{
convert_names
}
\examples{
transition_1 <- matrix(1, ncol = 2, nrow = 2)
colnames(transition_1) <- c("Stage1", "Stage2")
row.names(transition_1) <- c("Stage1", "Stage2")
col_name_new <- c("Stage1_new", "Stage2_new")
row_name_new <- c("Stage1_new", "Stage2_new")
transition_1 <- convert_names(row_name_new, col_name_new, transition_1)


}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
