% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.r
\name{replace.n.highest.risk}
\alias{replace.n.highest.risk}
\title{Rehabilitation strategy: replace the \code{n} pipes with the highest risk}
\usage{
replace.n.highest.risk(state, n, prob.failure, max.costs = Inf)
}
\arguments{
\item{state}{a state list}

\item{n}{number of highest risk pipes to replace}

\item{prob.failure}{failure rate function. Typically the same as passed to \code{\link{simulate_network}}.}

\item{max.costs}{maximal amount of money allowed to be spent on this strategy}
}
\value{
a state list
}
\description{
Strategy to prioritize pipes with the highest risk. Pipes are only
replaced if the budget remains positive.
}
\details{
The risk is defined as the product of the failure probability in the next year
and the expected failure costs.
}
\examples{
## define a strategy function that can be passed to simulate_network():
mystrategy <- . \%>\% replace.n.highest.risk(n=2, prob.failure=prob.failure.exp, max.costs=30000)

## or define a more complex strategy by combining multiple strategies
## into a prioritized sequence:
mystrategy <- . \%>\%
  replace.more.failures.than(failures=2) \%>\%
  replace.n.oldest(n=3) \%>\%
  replace.n.highest.risk(n=2, prob.failure=prob.failure.exp) \%>\%
  replace.older.than(age=8) \%>\%
  replace.n.random(n=4)

}
\seealso{
\code{\link{replace.n.oldest}}, \code{\link{replace.n.random}},
\code{\link{replace.older.than}},
\code{\link{replace.more.failures.than}}, \code{\link{do.nothing}}
}
\author{
Andreas Scheidegger
}
