% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Metabolomics_Rosettes}
\alias{Metabolomics_Rosettes}
\title{Metabolomics Rosettes}
\format{
A data frame with 30 rows and 6 variables:
\itemize{
\item \strong{Pectin_RGI}: Rhamnogalacturonan I (µg/100mg)
\item \strong{Pectin_HG}: Homogalacturonan (µg/100mg)
\item \strong{XG}: Xyloglucan (µg/100mg)
\item \strong{Pectin_linearity}: Linearity of pectin (Ratio)
\item \strong{Contribution_RG}: Contribution of rhamnogalacturonan to pectin population (Ratio)
\item \strong{RGI_branching}: Branching of Rhamnogalacturonan I (Ratio)
}
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Metabolomics_Rosettes")
}
\description{
A dataset containing metabolomics variables measured on rosettes of
five \emph{A. thaliana} genotypes at two growth temperatures.
See \link{Ecotype} and \link{Temperature} for more information.
}
\examples{
# Load the dataset
data("Metabolomics_Rosettes")

# Look at simple statistics
summary(Metabolomics_Rosettes)

# Create a colors' vector
colors <- c(rep("#A6CEE3",3), rep("#1F78B4",3), rep("#B2DF8A",3), rep("#33A02C",3),
            rep("#FB9A99",3), rep("#E31A1C",3), rep("#FDBF6F",3), rep("#FF7F00",3),
            rep("#CAB2D6",3), rep("#6A3D9A",3))

# A graphical representation
plot(x = as.factor(substr(row.names(Metabolomics_Rosettes), 1, 7)),
     y = Metabolomics_Rosettes$Pectin_linearity, col = "white", lty = 0,
     xlab = "Genotype x Temperature groups",
     ylab = "Pectin linearity (Ratio)",
     main = "Pectin linearity distribution by genotype and growth temperature")
grid()
abline(h = 1, lty = 2)
points(x = as.factor(substr(row.names(Metabolomics_Rosettes), 1, 7)),
       y = Metabolomics_Rosettes$Pectin_linearity, type = "p", pch = 19, lwd = 5,
       col = colors)

}
\keyword{datasets}
