% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Phenomics_Stems}
\alias{Phenomics_Stems}
\title{Phenomics Stems}
\format{
A data frame with 30 rows and 4 variables:
\itemize{
\item \strong{Mass}: floral stems mass (g)
\item \strong{Diameter}: floral stems diameter (mm)
\item \strong{Length}: length of the floral stems (cm)
\item \strong{Number_lateral_stems}: number of lateral stems)
}
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Phenomics_Stems")
}
\description{
A dataset containing phenotypic variables measured on floral stems of
five \emph{A. thaliana} genotypes at two growth temperatures.
See \link{Ecotype} and \link{Temperature} for more information.
}
\examples{
# Load the data
data("Phenomics_Stems")

# Look at simple statistics
dim(Phenomics_Stems)
summary(Phenomics_Stems)

# Create a colors' vector
colors <- c(rep("#A6CEE3",3), rep("#1F78B4",3), rep("#B2DF8A",3), rep("#33A02C",3),
            rep("#FB9A99",3), rep("#E31A1C",3), rep("#FDBF6F",3), rep("#FF7F00",3),
            rep("#CAB2D6",3), rep("#6A3D9A",3))

# A graphical representation: Lateral stems distribution
plot(x = as.factor(substr(row.names(Phenomics_Stems), 1, 7)),
     y = Phenomics_Stems$Number_lateral_stems, col = "white", lty = 0,
     xlab = "Genotype x Temperature groups",
     ylab = "Number of lateral stems",
     main = "Lateral stems' distribution by genotype and growth temperature"
     )
grid()
points(x = as.factor(substr(row.names(Phenomics_Stems), 1, 7)),
       y = Phenomics_Stems$Number_lateral_stems, type = "p", pch = 19, lwd = 5,
       col = colors)

}
\keyword{datasets}
