% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletLSTM.R
\name{WaveletLSTM}
\alias{WaveletLSTM}
\title{Wavelet Based LSTM Model}
\usage{
WaveletLSTM(
  ts,
  MLag = 12,
  split_ratio = 0.8,
  wlevels = 3,
  epochs = 25,
  LSTM_unit = 20
)
}
\arguments{
\item{ts}{Time Series Data}

\item{MLag}{Maximum Lags}

\item{split_ratio}{Training and Testing Split}

\item{wlevels}{Wavelet Levels}

\item{epochs}{Number of epochs}

\item{LSTM_unit}{Number of unit in LSTM layer}
}
\value{
\itemize{
  \item Train_actual: Actual train series
  \item Test_actual: Actual test series
  \item Train_fitted: Fitted train series
  \item Test_predicted: Predicted test series
  }
}
\description{
Wavelet Based LSTM Model
}
\examples{
\donttest{
y<-rnorm(100,mean=100,sd=50)
WTSLSTM<-WaveletLSTM(ts=y)
}
}
\references{
Paul, R.K. and Garai, S. (2021). Performance comparison of wavelets-based machine learning technique for forecasting agricultural commodity prices, Soft Computing, 25(20), 12857-12873
}
