% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_wavelet.R
\name{analyze_wavelet}
\alias{analyze_wavelet}
\title{Conduct the continuous wavelet transform on a time series/signal}
\usage{
analyze_wavelet(
  data = NULL,
  dj = 1/100,
  lowerPeriod = 2,
  upperPeriod = 1024,
  verbose = FALSE,
  omega_nr = 8,
  pval = FALSE,
  n_simulations = 10,
  run_multicore = FALSE
)
}
\arguments{
\item{data}{Input data, should be a matrix or data frame in which
the first column is depth or time and the second column is proxy record.}

\item{dj}{Spacing between successive scales. The CWT analyses analyses the signal using successive periods
which increase by the power of 2 (e.g.2^0=1,2^1=2,2^2=4,2^3=8,2^4=16). To have more resolution
in-between these steps the dj parameter exists, the dj parameter specifies how many extra steps/spacing in-between
the power of 2 scaled CWT is added. The amount of steps is 1/x with a higher x indicating a smaller spacing.
Increasing the increases the computational time of the CWT \code{Default=1/200}.}

\item{lowerPeriod}{Lowest period to be analyzed \code{Default=2}.
The CWT analyses the signal starting from the lowerPeriod to the upperPeriod so the proper selection these
parameters allows to analyze the signal for a specific range of cycles.
scaling is done using power 2 so for the best plotting results select a value to the power or 2.}

\item{upperPeriod}{Upper period to be analyzed \code{Default=1024}.
The CWT analyses the signal starting from the lowerPeriod to the upperPeriod so the proper selection these
parameters allows to analyze the signal for a specific range of cycles.
 scaling is done using power 2 so for the best plotting results select a value to the power or 2.}

\item{verbose}{Print text \code{Default=FALSE}.}

\item{omega_nr}{Number of cycles contained within the Morlet wavelet}

\item{pval}{calculate the P-value  \code{Default=FALSE}. The p-value is based on
Monte Carlo modelling runs on surrogate data generated based on autocorrelated noise (red noise) the calculated using a windowed
(the window is half the size of the data set) temporal autocorrelation
and on shuffling the data set resulting in a random data sets which has similar spectral characteristics
to the original data set.The shuffling of the data set creates white noise which ensures that high amplitude high frequency/short
period cycles do not result in statistical significant peaks. The part of the data generated using the  autocorrelated noise (red noise)
based on the windowed  (the window is half the size of the data set) temporal autocorrelation represent a spectral signature similar to
to that of the original data. The original data might include spectral peaks which are the result of astronomical
forcing. The result is that the spectral power profile is biased towards rejecting the 0-hypothesis (e.g. no astronomical forcing).
By combining the shuffling of the data set with autocorrelated noise a surrogate data set is created which rejects
high amplitude high frequency/short period cycles and a reduced biased towards towards rejecting the 0-hypothesis if the data was
solely the result of autocorrelated noise}

\item{n_simulations}{Number of simulation to be ran to generate the p-value}

\item{run_multicore}{Run p-value calculation with one core or multiple cores}
}
\value{
The output is a list (wavelet object) which contain 20 objects which are the result of the continuous wavelet transform (CWT).
Object 1: Wave - Wave values of the wavelet
Object 2: Phase - Phase of the wavelet
Object 3: Ampl - Amplitude values of the wavelet
Object 4: Power - Power values of the wavelet
Object 5: dt - Step size
Object 6: dj - Scale size
Object 7: Power.avg  - Average power values
Object 8: Period - Period values
Object 9: Scale - Scale value
Object 10: coi.1 - Cone of influence values 1
Object 11: coi.2 - Cone of influence values 2
Object 12: nc - Number of columns
Object 13: nr - Number of rows
Object 14: axis.1 - axis values 1
Object 15: axis.2 - axis values 2
Object 16: omega_nr - Number of cycles in the wavelet
Object 17: x - x values of the data set
Object 18: y - y values of the data set
Object 19: average p value of the spectral power
Object 20: p value of spectral power
}
\description{
Compute the continuous wavelet transform (CWT) using a Morlet wavelet
}
\examples{
\donttest{
#Example 1. Using the Total Solar Irradiance data set of Steinhilver et al., (2012)
TSI_wt <-
 analyze_wavelet(
   data = TSI,
   dj = 1/200,
   lowerPeriod = 16,
   upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6,
   pval=FALSE,
   n_simulations=10,
   run_multicore = FALSE
 )


#Example 2. Using the magnetic susceptibility data set of Pas et al., (2018)
mag_wt <-
analyze_wavelet(
data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10,
pval=FALSE,
n_simulations=10,
run_multicore = FALSE
)

#Example 3. Using the greyscale data set of Zeeden et al., (2013)
grey_wt <-
 analyze_wavelet(
   data = grey,
   dj = 1/200,
   lowerPeriod = 0.02,
   upperPeriod = 256,
   verbose = FALSE,
   omega_nr = 8,
   pval=FALSE,
   n_simulations=10,
   run_multicore = FALSE
 )

}
}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}

Morlet, Jean, Georges Arens, Eliane Fourgeau, and Dominique Glard.
"Wave propagation and sampling theory—Part I: Complex signal and scattering in multilayered media.
" Geophysics 47, no. 2 (1982): 203-221.

J. Morlet, G. Arens, E. Fourgeau, D. Giard;
Wave propagation and sampling theory; Part II, Sampling theory and complex waves.
 Geophysics 1982 47 (2): 222–236.
}
\author{
Code based on on the "WaveletComp" function of the 'WaveletComp' R package
and "wt" function of the 'biwavelet' R package which are based on the
wavelet MATLAB code written by Christopher Torrence and Gibert P. Compo.
}
