% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flmw.R
\name{flmw}
\alias{flmw}
\title{Fit linear models to spectral peaks extracted from the wavelet spectra to astronomical cycles multiplied by sedimentation rate x}
\usage{
flmw(
  wavelet = NULL,
  sedrate_low = NULL,
  sedrate_high = NULL,
  spacing = NULL,
  cycles = c(NULL),
  x_lab = "depth",
  y_lab = "sedrate",
  run_random = FALSE,
  rand_simulations = 1000,
  run_multicore = FALSE,
  genplot = FALSE,
  palette_name = "rainbow",
  color_brewer = "grDevices",
  plot_res = 2,
  keep_editable = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function}

\item{sedrate_low}{Minimum sedimentation rate (cm/kyr)for which the sum of maximum spectral power is calculated for.}

\item{sedrate_high}{Maximum sedimentation rate (cm/kyr) for which the sum of maximum spectral power is calculated  for.}

\item{spacing}{Spacing (cm/kyr) between sedimentation rates}

\item{cycles}{Astronomical cycles (in kyr) for which the combined sum of maximum spectral power is calculated for}

\item{x_lab}{label for the y-axis \code{Default="depth"}}

\item{y_lab}{label for the y-axis \code{Default="sedrate"}}

\item{run_random}{run multiple simulation to calculate percentile against the 0 hypothesis}

\item{rand_simulations}{nr of simulations to calculate percentile against the 0 hypothesis}

\item{run_multicore}{run simulation using multiple cores \code{Default=FALSE}
the simulation is run at x-2 cores to allow the 2 remaining processes to run background processes}

\item{genplot}{Generate plot \code{Default="FALSE"}}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{plot_res}{options 1-8 option 1: slope coefficient, option 2: r squared,
option 3: nr of components, option 4: difference to the  origin , option 5: slope coefficient percentile
option 6: r squared percentile, option 7: nr of components percentile,
option 8: difference to the origin percentile \code{Default=2}}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{verbose}{Print text \code{Default=FALSE}.}
}
\value{
Returns a list which contains 10 elements
element 1: slope coefficient
element 2: r squared
element 3: nr of components
element 4: difference to the origin
element 5: slope coefficient percentile
element 6: r squared percentile
element 7: nr of components percentile,
element 8: difference to the origin percentile
element 9: y-axis values of the matrices which is sedimentation rate
element 10: x-axis values of the matrices which is depth
}
\description{
The \code{\link{flmw}} function is used calculate the linear correlation
for a list of astronomical cycles transformed using a range of sedimentation rates and then compared
to spectral peaks of a wavelet spectra
}
\examples{
\donttest{
#estimate sedimentation rate for the magnetic susceptibility record
# of the Sullivan core of Pas et al., (2018).

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

sedrates <- flmw(wavelet = mag_wt,
    sedrate_low = 0.5,
    sedrate_high = 4,
    spacing = 0.05,
    cycles = c(2376,1600,1180,696,406,110),
    x_lab = "depth",
    y_lab = "sedrate",
    run_random = FALSE,
    rand_simulations = 50, # increase to get better constrainted resutls
    run_multicore = FALSE,
    genplot = FALSE,
    palette_name = "rainbow",
    color_brewer = "grDevices",
    plot_res = 2,
    keep_editable=FALSE,
    verbose=FALSE)
}

}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>

Acycle: Time-series analysis software for paleoclimate research and education,
Mingsong Li, Linda Hinnov, Lee Kump,
Computers & Geosciences,Volume 127,2019,Pages 12-22,ISSN 0098-3004,
<doi:10.1016/j.cageo.2019.02.011>

Tracking variable sedimentation rates and astronomical forcing in Phanerozoic paleoclimate proxy series with evolutionary correlation coefficients and hypothesis testing,
Mingsong Li, Lee R. Kump, Linda A. Hinnov, Michael E. Mann,
Earth and Planetary Science Letters,Volume 501,
T2018,Pages 165-179,ISSN 0012-821X,<doi:10.1016/j.epsl.2018.08.041>
}
\author{
Based on the \link[astrochron]{eAsm} function of the 'astrochron' R package and the 'eCOCO' and 'COCO' function of the 'Acycle' software
}
