% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sedrate2tune.R
\name{sedrate2tune}
\alias{sedrate2tune}
\title{Use a sedimentation curve to convert data to the time domain}
\usage{
sedrate2tune(
  data = NULL,
  sed_curve = NULL,
  genplot = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{data}{Input should be a matrix of 2 columns with first column being depth and the second column
is a proxy value}

\item{sed_curve}{Input should be a matrix of 2 columns with first column being depth and the second column
is the sedimentation rate is cm/kyr}

\item{genplot}{Generates a plot of the proxy record in  the time domain \code{Default=FALSE}.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
The output is a matrix with 2 columns.
The first column is time
The second column is the proxy value
If \code{genplot=TRUE} then a time vs proxy value plot will be plotted.
}
\description{
Convert a proxy record from the depth to time domain using
a sedimentation rate curve
}
\examples{
\donttest{
# Extract the 405kyr eccentricity cycle from the wavelet scalogram
# from the magnetic susceptibility record of the Sullivan core
# of Pas et al., (2018) and then create a age model using minimal tuning
# (e.g.) set the distance between peaks to 405 kyr. The age model
# (sedimentation rate curve) is then used to convert the data
# from the depth to the time domain

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)


mag_405 <- extract_signal_stable_V2(
 wavelet = mag_wt,
 period_max = 4,
 period_min = 2,
 add_mean = TRUE,
 plot_residual = FALSE,
 keep_editable = FALSE
)

mag_405_min_tuning <- minimal_tuning(data = mag_405,
pts = 5,
cycle = 405,
tune_opt = "max",
output = 1,
genplot = FALSE,
keep_editable = FALSE)

mag_time <- sedrate2tune(
data=mag,
sed_curve=mag_405_min_tuning,
genplot=FALSE,
keep_editable=FALSE)

}
}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
Part of the code is based on the \link[astrochron]{sedrate2time}
function of the 'astrochron' R package
}
