% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightedEnsemble.R
\name{WeightedEnsemble}
\alias{WeightedEnsemble}
\title{Weighted Ensemble for Hybrid Model}
\usage{
WeightedEnsemble(df, Method = "PSO", test_data = NULL, forecast = NULL)
}
\arguments{
\item{df}{Data set (training result) with first column as observed value}

\item{Method}{Method of optimization}

\item{test_data}{Test result}

\item{forecast}{Forecast result}
}
\value{
\itemize{
  \item Weights: Optimized weight
  \item Optimized_Result: Optimized result
  }
}
\description{
Weighted Ensemble for Hybrid Model
}
\examples{
\donttest{
y1<-rnorm(100,mean=100,sd=50)
y2<- rnorm(100,mean=100,sd=50)
y3<- rnorm(100,mean=100,sd=50)
y4<-rnorm(100,mean=100,sd=50)
y<-rnorm(100,mean=100,sd=50)
data<-cbind(y,y1,y2,y3,y4)
OptiSemble<-WeightedEnsemble(df=data)
}
}
\references{
J. S. Armstrong. Combining forecasts: The end of the beginning or the beginning of the end? International Journal of Forecasting, 5(4):585–588, 1989.
}
