% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{vector_R-class}
\alias{vector_R-class}
\alias{vector_R}
\title{A class that facilitates returning R vectors via a list in JSON}
\description{
Server language code will return a dictionary in which data= is a JSON-style list
and type= is the R vector type desired.  See the asRObject() method documentation.
Objects from this class can also be generated in R, usually supplying just \code{data}
and generating the other slots from that object's properties.
}
\section{Slots}{

\describe{
\item{\code{data}}{The actual vector data.}

\item{\code{type}}{The string for the \R type intended. In spite of the slot name, this really the class;
for example, "numeric" rather than "double".}

\item{\code{missing}}{The index of NA's in this vector.  Needed because most server languages only
treat `NaN` for doubles and have no mechanism for `NA` in other types.}
}}

\examples{
x <- c(1:2,NA,4:5)
vector_R(x)
}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
