% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_bout.R
\name{optimize_biexponential}
\alias{optimize_biexponential}
\alias{biexponential_log_likelihood}
\title{Optimization Function for the Biexponential Model}
\usage{
optimize_biexponential(irt)

biexponential_log_likelihood(params, irt)
}
\arguments{
\item{irt}{A numeric vector representing inter-response times.}

\item{params}{A numeric vector of initial parameter estimates for optimization.}
}
\value{
A named vector of optimized parameters for the biexponential model.

Negative log-likelihood value used for parameter estimation.
}
\description{
Optimizes the log-likelihood function to estimate biexponential model parameters based on observed inter-response times.

Calculates the negative log-likelihood for the simpler biexponential model, which does not include the
refractory period parameter, \eqn{\delta}.
}
\details{
This function computes the negative log-likelihood based on biexponential functions
for the simpler biexponential model, adjusting parameters using transformations to meet constraints.
}
