% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_ypbp.R
\name{crossTime.ypbp}
\alias{crossTime.ypbp}
\title{Computes the crossing survival times}
\usage{
\method{crossTime}{ypbp}(object, newdata1, newdata2, conf.level = 0.95, nboot = 4000, ...)
}
\arguments{
\item{object}{an object of class ypbp}

\item{newdata1}{a data frame containing the first set of explanatory variables}

\item{newdata2}{a data frame containing the second set of explanatory variables}

\item{conf.level}{level of the confidence/credible intervals; default is conf.level = 0.95}

\item{nboot}{number of bootstrap samples (default nboot=4000); ignored if approach="bayes".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the crossing survival time
}
\description{
Computes the crossing survival times along with their corresponding confidence/credible intervals.
}
\examples{
\donttest{
# ML approach:
library(YPBP)
mle <- ypbp(Surv(time, status)~arm, data=ipass, approach="mle")
summary(mle)
newdata1 <- data.frame(arm=0)
newdata2 <- data.frame(arm=1)
tcross <- crossTime(mle, newdata1, newdata2, nboot = 100)
tcross
ekm <- survival::survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(mle, newdata)
plot(ekm, col=1:2)
with(St, lines(time, surv[[1]]))
with(St, lines(time, surv[[2]], col=2))
abline(v=tcross, col="blue")

# Bayesian approach:
bayes<-ypbp(Surv(time,status)~arm,data=ipass,approach="bayes",chains=2,iter=100)
summary(bayes)
newdata1 <- data.frame(arm=0)
newdata2 <- data.frame(arm=1)
tcross <- crossTime(bayes, newdata1, newdata2)
tcross
ekm <- survival::survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(bayes, newdata)
plot(ekm, col=1:2)
with(St, lines(time, surv[[1]]))
with(St, lines(time, surv[[2]], col=2))
abline(v=tcross, col="blue")
}

}
