% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchPreProcessing.R
\name{batchPreProcessing}
\alias{batchPreProcessing}
\title{batchPreProcessing}
\usage{
batchPreProcessing(
  zpFileDir,
  zpSaveDir,
  minPixels = 5000,
  imageExtension = ".jpg",
  noRepeats = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{zpFileDir}{Directory full of zooplankton images to extract}

\item{zpSaveDir}{Directory to save the extracted images to}

\item{minPixels}{Integer specifying the minimum number of pixels allowed in an extracted image
Any extracted image with fewer pixels will not be saved
[Default:  5000 (~70 by 70 pixels)]}

\item{imageExtension}{String specifying the extension the images will have (must include ".")
[Default: ".jpg"]}

\item{noRepeats}{Boolean variable to decide whether to ignore images that are already present in
the save dir, or not [Default: TRUE]}

\item{verbose}{Boolean variable indicating whether the script should print info to console
[Default: TRUE]}
}
\description{
Preprocessing a directory of zooplankton images
}
\examples{
\dontrun{
zpFileDir <- 'Users/$(whoami)/Images/ZooplanktonImages/ostracod'
zpSaveDir <- 'Users/$(whoami)/Images/ExtractedImages/ostracod'
batchPreProcessing(zpFileDir, zpSaveDir)
}
}
