% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKNCA.R
\name{PKNCA_update_data_object}
\alias{PKNCA_update_data_object}
\title{Create a PKNCAdata Object for NCA or Slope Analysis}
\usage{
PKNCA_update_data_object(
  adnca_data,
  auc_data,
  method,
  selected_analytes,
  selected_profile,
  selected_pcspec,
  params,
  should_impute_c0 = TRUE
)
}
\arguments{
\item{adnca_data}{A reactive PKNCAdata object}

\item{auc_data}{A data frame containing partial aucs added by user}

\item{method}{NCA calculation method selection}

\item{selected_analytes}{User selected analytes}

\item{selected_profile}{User selected dose numbers/profiles}

\item{selected_pcspec}{User selected specimen}

\item{params}{A list of parameters for NCA calculation}

\item{should_impute_c0}{Logical indicating if start values should be imputed}
}
\value{
A fully configured \code{PKNCAdata} object.
}
\description{
This function updates a previously prepared \code{PKNCAdata} object
based on user selections for method, analyte, dose, specimen, and parameters.
}
\details{
Step 1: Update units in the \code{PKNCAdata} object
ensuring unique analytes have their unique units

Step 2: Set \code{PKNCAoptions} for NCA calculation

Step 3: Format intervals using \code{format_pkncadata_intervals()}

Step 4: Apply filtering based on user selections and partial aucs

Step 5: Impute start values if requested

Note*: The function assumes that the \code{adnca_data} object has been
created using the \code{PKNCA_create_data_object()} function.
}
