% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexible_violinboxplot.R
\name{flexible_violinboxplot}
\alias{flexible_violinboxplot}
\title{Flexible Violin/Box Plot}
\usage{
flexible_violinboxplot(
  res_nca,
  parameter,
  xvars,
  colorvars,
  varvalstofilter = NULL,
  columns_to_hover,
  box = TRUE,
  plotly = TRUE,
  seed = NULL
)
}
\arguments{
\item{res_nca}{A PKNCA results object containing the results and concentration data.}

\item{parameter}{A string specifying the parameter to be plotted.}

\item{xvars}{Variables for the x axis.}

\item{colorvars}{Variables for the color aesthetic.}

\item{varvalstofilter}{Character vector specifying which variable and value to pre-filter
as \code{colname: value}. By default is NULL (no pre-filtering)}

\item{columns_to_hover}{A character vector indicating the column names from result_data that
should be used to identify when hovering the plotly outputs}

\item{box}{A logical value indicating whether to plot a box plot (\code{TRUE}) or a
violin plot (\code{FALSE}). Default is \code{TRUE}.}

\item{plotly}{A logical value defining if the output is plotly (TRUE, default)
or ggplot otherwise (FALSE)}

\item{seed}{An integer value to set the seed for reproducibility of jittering.
Default (NULL) will use the current R seed.}
}
\value{
A plotly object representing the violin or box plot.
}
\description{
This function generates a  violin or box plot based on the provided data,
parameter, and dose information.
}
