% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{metadata_nca_variables}
\alias{metadata_nca_variables}
\title{metadata_nca_variables}
\format{
A data frame with 361 rows and 14 variables:
\describe{
\item{Dataset}{Character. Indicates the dataset the variable belongs to (PP, ADNCA, ADPP).}
\item{Order}{Numeric. Variable order within its domain, based on Role, Core and Variable}
\item{Variable}{Character. The short name of the variable.}
\item{Label}{Character. A descriptive label for the variable.}
\item{Type}{Character. Data type of the variable (Char, Num, text, integer, float, dateTime).}
\item{Role}{Character. The CDISC role of the variable (e.g., Identifier, Topic, Timing...).}
\item{Core}{Character. Indicates the core status of the variable
(Req = Required, Perm = Permissible, Exp = Expected, Cond = Conditional).}
\item{company_specific}{Logical. Indicates if the variable is company-specific (not CDISC).}
\item{is.core}{Logical. TRUE if the variable is a core variable (always needed to be present).}
\item{Length}{Numeric. The maximum length of the variable.}
\item{Controlled_Terms}{Character. Reference to controlled terminology (e.g., C85839, C66731).}
\item{is.used}{Logical. TRUE if the variable is meant to be included.}
\item{Values}{Character. Possible values (if applicable) for the variable separated by ', '.}
\item{is.mapped}{Logical. TRUE if the variable is mapped in ADNCA (App's input).}
\item{mapping_tooltip}{Character. Tooltip text for mapping guidance in the App.}
\item{mapping_section}{Character. Mapping section where the variable is classified in the App.}
\item{mapping_alternatives}{Character. Alternative column names for the variable.}
\item{mapping_order}{Numeric. Defines the mapped variables order in the mapped dataset}
}
}
\source{
Used for PP and ADPP mapping rules and checks in the export_cdisc function
}
\usage{
metadata_nca_variables
}
\description{
A dataset containing pharmacokinetic variable specifications.
}
\keyword{datasets}
