% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_dose_qc_plot.R
\name{prepare_plot_data}
\alias{prepare_plot_data}
\title{Prepare Data for PK Dose QC Plotting}
\usage{
prepare_plot_data(
  data_conc,
  data_dose,
  shape_var,
  colour_var,
  grouping_vars,
  labels_df,
  tooltip_vars,
  plot_conc_data,
  plot_dose_data
)
}
\arguments{
\item{data_conc}{A data.frame of concentration data.}

\item{data_dose}{An optional data.frame of dosing data.}

\item{shape_var}{Character. The column name from \code{data_conc} for the legend.}

\item{colour_var}{Character. The column name from \code{data_dose} for the legend.}

\item{grouping_vars}{Character vector. Column names for faceting.}

\item{labels_df}{A data.frame for label lookups.}

\item{tooltip_vars}{Character vector of variables for the tooltip.}

\item{plot_conc_data}{Logical flag derived from \code{show_pk_samples} and \code{data_conc}.}

\item{plot_dose_data}{Logical flag derived from \code{show_doses} and \code{data_dose}.}
}
\value{
A \code{list} containing \code{data} (the processed tibble), \code{shape_levels},
and \code{colour_levels}.
}
\description{
A helper function that validates, processes, and combines
concentration and dose data. It creates the unified legend and faceting
variables and calculates the factor levels for the plot scales.
}
