% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_nebula.R
\name{canvas_nebula}
\alias{canvas_nebula}
\title{Draw Nebulas}
\usage{
canvas_nebula(
  colors,
  k = 50,
  n = 500,
  resolution = 500
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{k}{a positive integer specifying the number of nearest neighbors to consider.}

\item{n}{a positive integer specifying the number of random data points to generate.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork from randomly generated k-nearest neighbors noise.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_nebula(colors = colorPalette("tuscany1"))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
